#include <iostream>
#include <algorithm>
using namespace std;

#define x first
#define y second

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

using namespace std;

typedef long long ll;

const int MAXN = 1000100;
const int MAXM = 100100;
const int INF = (1 << 30) - 2;

int n, L, R, min_h = INF;
int l[MAXN];
int h[MAXN];
ll sum_l[MAXN];

struct tournament {
  static const int off = 1 << 20;
  pair<int, int> data[2*off]; // pamtim min i max
  int from, to;

  pair<int, int> merge(const pair<int, int> &a, const pair<int, int> &b) {
    pair<int, int> ret;
    ret.x = min(a.x, b.x);
    ret.y = max(a.y, b.y);
    return ret;
  }

  void init() {
    for (int i = 0; i < 2*off; ++i)
      data[i] = {INF, -INF};
    for (int i = 0; i < n; ++i)
      data[i+off] = {h[i], h[i]};
    for (int i = off-1; i > 0; --i) {
      data[i] = merge(data[i+i], data[i+i+1]);
    }
  }

  pair<int, int> query(int nd, int lo, int hi) {
    if (lo >= from && hi <= to) return data[nd];
    if (lo >= to || hi <= from) return {INF, -INF};
    int mid = (lo + hi) / 2;
    return merge(query(2*nd, lo, mid), query(2*nd+1, mid, hi));
  }

  pair<int, int> query(int lll, int rrr) {
    from = lll, to = rrr+1;
    return query(1, 0, off);
  }
} T;


int p2p(ll x) {
  int p = lower_bound(sum_l, sum_l+n, x) - sum_l;
  if (sum_l[p] > x) --p;
  return p;
}

pair<int, int> query(ll left, ll right) {
  return T.query(p2p(left), p2p(right));
}


int solve() {
  static int k, LI, RI, max_hi = -INF;
  static int li[MAXN], hi[MAXN];
  static ll sum_li[MAXN];
  static pair<int, int> stat[MAXN];
  
  cin >> k;
  for (int i = 0; i < k; ++i)
    cin >> li[i] >> hi[i];

  max_hi = -INF;
  for (int i = 0; i < k; ++i) {
    if (hi[i] > max_hi) {
      max_hi = hi[i];
      LI = i;
    }
    if (hi[i] == max_hi) {
      RI = i;
    }
  }
 
  for (int i = 0; i < k; ++i)
    sum_li[i+1] = sum_li[i] + li[i];

  // ako se granice za najnizi sloj ne poklapaju
  if (sum_li[RI+1] - sum_li[LI] != sum_l[R+1] - sum_l[L]) {
    return 0;
  }

  // na koju visinu ga spustam
  int H = 0;
 
  for (int i = 0; i < k; ++i) {
    ll left = sum_l[L] - (sum_li[LI] - sum_li[i]);
    ll right = sum_l[L] - (sum_li[LI] - sum_li[i+1]) - 1;
    stat[i] = query(left, right);
    H = max(H, stat[i].y + hi[i]);
    //TRACE(left _ right _ p2p(left) _ p2p(right));
  }

 // TRACE(H);

  // do koje visine ce sve biti popunjeno
  int ref_h = H;
  for (int i = 0; i < k; ++i)
    if (stat[i].x + hi[i] != H)
      ref_h = min(ref_h, stat[i].x);

  int inv1 = p2p(sum_l[L] - sum_li[LI] - 1);
  int inv2 = p2p(sum_l[L] - sum_li[LI] + sum_li[k]);
  if (inv1 >= 0) ref_h = min(ref_h, T.query(0, inv1).x);
  ref_h = min(ref_h, T.query(inv2, n).x);

  return ref_h;
}

int main(void) {
  cin >> n;
  for (int i = 0; i < n; ++i)
    cin >> l[i] >> h[i];
  
  L = n, R = 0;
  for (int i = 0; i < n; ++i) {
    if (h[i] == 0) {
      L = min(L, i);
      R = max(R, i);
    } 
  }

  T.init();
  for (int i = 0; i < n; ++i)
    sum_l[i+1] = sum_l[i] + l[i];

  int q;
  cin >> q;
  while (q--) {
    cout << solve() << endl;
  }

  return 0;
}

